#include <Array.au3>
#include <ArrayMore.au3>
#include <File.au3>
#include <String.au3>
#include <StructureConstants.au3>
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Res_Description=AutoIt Hilfe checken
#AutoIt3Wrapper_Res_Fileversion=1.0.0.20
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_Field=AutoIt Version|%AutoItVer%
#AutoIt3Wrapper_Res_Field=Autor|Tweaky
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

;Was macht dieses Skript
;Funktionsname prfen
;Funktionsname im Syntax prfen
;existieren die Includes
;stimmen die Variablen im Syntax mit denen in der Erklrung berein? (Anzahl, Reihenfolge, korrekte Schreibweise)
;Verwandte Funktionen prfen (existieren die Dateien, sind sie nicht doppelt, ungleich der aktuellen Funktion)
;Sind alle berschriften vorhanden
;Ist die berschrift fr das Bsp vorhanden mu es auch ein Bsp geben
;Ist die keine berschrift fr das Bsp vorhanden darf es auch kein Bsp geben
;Es wird geprft, ob das Wort "@@End@@" ausreichend enthalten ist
;Es wird geprft, ob eine Leerzeile vor dem "@@End@@" vorhanden ist
;Es wird geprft: Bei der Datei gibt es eine verwandte Funktion. Verweist diese verwandte Funktion auch wieder zurck? (Grundfunktionen verweisen nicht auf UDFs und andersrum)
;Es wird geprft, ob das Wort [Optional] im Syntax bzw. in der Beschreibung korrekt angewendet wurde

Dim $array_txt
Dim $zeile_syntax, $zeile_include
Dim $name_funktion_dateiname, $name_funktion_dateiname_merken, $anzahl_fehler
Dim $array_alle_verwandte[1][2]

$ini_verwandte = @ScriptDir & "\" & "verwandte.ini"
FileDelete($ini_verwandte)

;Pfad mit den Quelldateien
;Path to the source files
;~ $grundpfad = "D:\_AutoIt Hilfe\3.3.0.0 2009.03.26 deutsch alles\txt2htm\"
$grundpfad = "D:\AutoIt-WebSVN\trunk\docs\autoit\english\txt2htm\"
;~ $grundpfad = "C:\translation\txt2htm\"

;~ $grundpfad = "C:\aaa\txt2htm\" ;Pfad mit den kompletten Sourcedaten der Hilfe 			;path with the complete source data files



;Hier mu umgestellt werden, wenn eine Version verwendet wird die nicht installiert ist
;This must be changed when a version is used that is not installed
;~ $pfad_include = RegRead('HKEY_LOCAL_MACHINE\SOFTWARE\AutoIt v3\AutoIt', 'InstallDir') & '\Include\' ;Include Ordner fr eine installierte Version
$pfad_include = 'D:\AutoIt-WebSVN\trunk\install\Include\' ;Include Ordner fr eine Version die nicht installiert ist


$pfad_1 = $grundpfad & "txtFunctions\"
$pfad_2 = $grundpfad & "txtKeywords\"
$pfad_3 = $grundpfad & "txtlibfunctions\"
$pfad_4 = $grundpfad & "examples\"
$pfad_5 = $grundpfad & "libExamples\"

;Pfad zu den genderten Dateien (das Wort "optional" wurde ergnzt)
;Path to the changed files (the word "optional" has been completed)
$grundpfad_geaenderte = "C:\geaendert_optional\"
DirRemove($grundpfad_geaenderte, 1)


Dim $1 = "", $2 = "", $3 = "", $4 = "", $5 = "", $6 = "", $7 = "", $8 = "", $9 = "", $10 = "", $11 = "", $12 = "", $13 = "", $14 = "", $15 = "", $16 = "", $17 = "", $18 = "", $19 = "", $20 = "", $21 = ""

;deutsche Fehlerbeschreibung
;Hier kann man die Fehler aktivieren oder deaktivieren nach denen gesucht werden soll
;~ $1 = "Funktionsname bei ###Function### falsch"
;~ $2 = "Funktionsname im Syntax falsch"
;~ $3 = "angegebene Include-Datei existiert nicht"
;~ $4 = "Anzahl Variablen / Variablen unterschiedlich geschrieben / Variablen in unterschiedlicher Reihenfolge" & @TAB & @TAB & "(ist | soll)" & @TAB
;~ $5 = "Verwandte Funktion existiert nicht"
;~ $6 = "Verwandte Funktion doppelt"
;~ $7 = "Verwandte Funktion gleich der aktuellen Funktion"
;~ $8 = "Eintrag fr das Beispiel vorhanden / Beispieldatei fehlt"
;~ $9 = "Eintrag fr das Beispiel fehlt / Beispieldatei existiert"
;~ $10 = "Anzahl von @@End@@ stimmt nicht"
;~ $11 = "berschrift fr Art der Funktion fehlt (z. B. ###Function###)"
;~ $12 = "berschrift fr Beschreibung fehlt (###Description###)"
;~ $13 = "berschrift fr Syntax fehlt (###Syntax###)"
;~ $14 = "berschrift fr Parameter fehlt (###Parameters###)"
;~ $15 = "berschrift fr Rckgabewert fehlt (###ReturnValue###)"
;~ $16 = "berschrift fr Bemerkungen fehlt (###Remarks###)"
;~ $17 = "berschrift fr Verwandte Funktion fehlt (###Related###)"
;~ $18 = "Leerzeile oberhalb @@End@@"
;~ $19 = "Gegenseitiges verweisen stimmt nicht"
;~ $20 = 'Das Wort "[optional]" fehlt, wurde falsch geschrieben oder ist unntig in der Beschreibung (mindestens bei einer Variable)'
;~ $21 = "Link fehlerhaft" ;funktioniert nur wenn der Pfad mit den kompletten Sourcedaten der Hilfe angegeben wird!!!




;englische Fehlerbeschreibung
;Here you can enable or disable the error should be searched
;~ $1 = "Function name at ###Function### wrong"
;~ $2 = "Function name at Syntax wrong"
;~ $3 = "Specified Include-file does not exist"
$4 = "Number of variables wrong / variables differently / variables in different order" & @TAB & @TAB & "(is | should)" & @TAB
;~ $5 = "Related function does not exist"
;~ $6 = "Related function twice"
;~ $7 = "Related function equal to the current function"
;~ $8 = "Entry exists for the example / sample file is missing"
;~ $9 = "Entry for the missing example / sample file exists"
;~ $10 = "Number of @@End@@ mismatch"
;~ $11 = "Missing header for the type of function (eg ###Function###)"
;~ $12 = "Missing header for description (###Description###)"
;~ $13 = "Missing header for syntax (###Syntax###)"
;~ $14 = "Missing header for parameter (###Parameters###)"
;~ $15 = "Missing header for return value (###ReturnValue###)"
;~ $16 = "Missing header for remarks (###Remarks###)"
;~ $17 = "Missing header for related function (###Related###)"
;~ $18 = "Blank line above @@End@@"
$19 = "Mutual does not refer"
$20 = 'The word "[optional]" is missing, has been misspelled or is unnecessary in the description (at least one variable)'
;~ $21 = "Link errors" ;only works if the path is specified with the complete source data files!




;~ $wort_optional = "<b>Optional:</b>"
$wort_optional = "[optional]"

;folgende Funktion werden nicht geprft, falls der Dateiname, Variablen ist und Variablen soll bereinstimmt (z. B. x und y sind im Syntax getrennt, aber in der Beschreibung zusammengefasst)
Dim $array_auslassen_anz_var[7][3] = [ _
		[0, 0, 0],["Call.txt", 1, 4],["DllCall.txt", 3, 7],["GUICtrlSetGraphic.txt", 2, 4],["MouseClick.txt", 1, 5],["MouseClickDrag.txt", 1, 6], _
		["StringFormat.txt", 1, 3]]
;~ 		["StringFormat.txt", 1, 3],["$tagWIN32_FIND_DATA.txt", 10, 11]]	; JP: to go around something I don't understand
;~ 		["StringFormat.txt", 1, 3],["ToolTip.txt", 1, 6],["$tagNMTOOLBAR.txt", 6, 16],["_WordMacroRun.txt", 3, 6]]

;bei bestimmten Sachen "optional" nicht suchen (z. B. x, y) (Funktion taucht 2x im Skript auf)
Dim $array_auslassen_optional[3] = [0, "MouseClick.txt", "_WordMacroRun.txt"]

;taucht in den verwandten Funktionen "GUICtrlCreate..." auf, so wird simuliert, dass die Funktion auf die verwandte Funktion verweist und andersrum
Dim $array_sammelfunc_1[31] = [0, "GUICtrlCreateAvi", "GUICtrlCreateButton", "GUICtrlCreateCheckbox", "GUICtrlCreateCombo", "GUICtrlCreateContextMenu", _
		"GUICtrlCreateDate", "GUICtrlCreateDummy", "GUICtrlCreateEdit", "GUICtrlCreateGraphic", "GUICtrlCreateGroup", _
		"GUICtrlCreateIcon", "GUICtrlCreateInput", "GUICtrlCreateLabel", "GUICtrlCreateList", "GUICtrlCreateListView", _
		"GUICtrlCreateListViewItem", "GUICtrlCreateMenu", "GUICtrlCreateMenuItem", "GUICtrlCreateMonthCal", "GUICtrlCreateObj", _
		"GUICtrlCreatePic", "GUICtrlCreateProgress", "GUICtrlCreateRadio", "GUICtrlCreateSlider", "GUICtrlCreateTab", _
		"GUICtrlCreateTabItem", "GUICtrlCreateTreeView", "GUICtrlCreateTreeViewItem", "GUICtrlCreateUpdown", "GUICtrlDelete"]

;taucht in den verwandten Funktionen "GUICtrlUpdate..." auf, so wird simuliert, dass die Funktion auf die verwandte Funktion verweist und andersrum
Dim $array_sammelfunc_2[18] = [0, "GUICtrlRegisterListViewSort", "GUICtrlSetBkColor", "GUICtrlSetColor", "GUICtrlSetCursor", "GUICtrlSetData", _
		"GUICtrlSetDefBkColor", "GUICtrlSetDefColor", "GUICtrlSetFont", "GUICtrlSetGraphic", "GUICtrlSetImage", "GUICtrlSetLimit", "GUICtrlSetOnEvent", _
		"GUICtrlSetPos", "GUICtrlSetResizing", "GUICtrlSetState", "GUICtrlSetStyle", "GUICtrlSetTip"]

;"GUISetParameters..."
Dim $array_sammelfunc_3[11] = [0, "GUISetAccelerators", "GUISetBkColor", "GUISetCoord", "GUISetCursor", "GUISetFont", _
		"GUISetHelp", "GUISetIcon", "GUISetOnEvent", "GUISetState", "GUISetStyle"]

Dim $array_nobackref[10] = [0, "WinActivate", "StringSplit", "String", "Binary", "GUICtrlGetHandle", "BinaryLen", "BinaryMid", "BitAnd", "_WinAPI_GetLastError"]
$check_backref = 0 ; 0 to ignore the back reference

;************************************************************************************************************************************************************************************************************************************************
;************************************************************************************************************************************************************************************************************************************************
;************************************************************************************************************************************************************************************************************************************************
;************************************************************************************************************************************************************************************************************************************************
;************************************************************************************************************************************************************************************************************************************************
;************************************************************************************************************************************************************************************************************************************************
;************************************************************************************************************************************************************************************************************************************************



$array_dateien = _FileListToArray($pfad_1, "*.txt", 1) ;Grundfunktionen
_ermitteln($pfad_1)
$array_dateien = _FileListToArray($pfad_2, "*.txt", 1) ;Schlsselwrter
_ermitteln($pfad_2)
$array_dateien = _FileListToArray($pfad_3, "*.txt", 1) ;UDFs
_ermitteln($pfad_3)
;~ _ArrayDisplay($array_dateien)
;~ exit

If $19 <> "" Then _verwandte_fehlen() ;fehlende verwandte Funktionen ermitteln



;******************************
;Hauptfunktion
;******************************

Func _ermitteln($pfad)
	For $i = 1 To UBound($array_dateien) - 1
		$name = $pfad & $array_dateien[$i] ;kompletter Pfad der einzelnen Datei
		_FileReadToArray($name, $array_txt) ;Zeilen der Datei in ein Array schreiben
		$anzahl_variablen_ist = 0 ;Anzahl der Variablen in der Funktion im Syntax
		$array_zaehler = 1 ;Anzahl Variablen
		$zeile_syntax = 0 ;Zeile in der sich der Syntax befindet
		$zeile_include = 0 ;Zeile in der sich das erste Include befindet
		$variable_erledigt = 0 ;notwendig, da sonst die Fehlermeldung mit den Variablen mehrfach kommt
		$tabelle_beginn = 0 ;Anzahl der Tabellen Beginn
		$tabelle_ende = 0 ;Anzahl der Tabellen Ende
		$funktion_art = 0 ;berschrift ber dem Funktionsname vorhanden?
		$syntax = 0 ;berschrift ber dem Syntax vorhanden?
		$parameter = 0 ;berschrift ber den Parameters vorhanden?
		$verwandte_funcs = 0 ;berschrift ber den verwandten Funktionen vorhanden?
		$beschreibung = 0 ;berschrift ber der Beschreibung vorhanden?
		$rueckgabewert = 0 ;berschrift ber dem Rckgabewert vorhanden?
		$bemerkungen = 0 ;berschrift ber den Bemerkungen vorhanden?
		$beispiel = 0 ;berschrift ber dem Beispiel vorhanden?
		$beispiel_include = 0 ;berschrift ber dem Beispiel vorhanden?
		$name_funktion_dateiname = StringTrimRight($array_dateien[$i], 4) ;Dateiname ohne Endung


		;*******************************************************************************
		;Es wird geprft, ob das Wort "@@End@@" ausreichend enthalten ist
		;Es wird geprft, ob ber dem Wort "@@End@@" eine Leerzeile ist
		;*******************************************************************************
		For $z = 1 To UBound($array_txt) - 1
			If StringInStr($array_txt[$z], '@@ParamTable@@') Or StringInStr($array_txt[$z], '@@ControlCommandTable@@') Or StringInStr($array_txt[$z], '@@StandardTable1@@') Or StringInStr($array_txt[$z], '@@ReturnTable@@') Or StringInStr($array_txt[$z], '@@ParamTable@@') Then $tabelle_beginn += 1
			If StringInStr($array_txt[$z], '@@End@@') Then
				$tabelle_ende += 1
				If $array_txt[$z - 1] = "" Then _log_schreiben($18, "")
			EndIf

			;Links testen
			If $21 <> "" And StringInStr($array_txt[$z], 'href=') Then
				$link_tmp = _StringBetween($array_txt[$z], 'href="', '"') ;Link herausfiltern
				$link = $link_tmp[0]
				If StringInStr($link, '#') Then ;falls ein # enthlt Link herausfiltern
					$link_tmp = StringSplit($link, '#')
					$link = $link_tmp[1]
				EndIf

				If Not StringInStr($link, "\") And Not StringInStr($link, "/") Then
					If StringInStr($pfad, "txtfunctions") Then
						$link = StringReplace($grundpfad, "txt2htm", "html") & "functions\" & $link ;neuen Pfad setzen
					ElseIf StringInStr($pfad, "txtkeywords") Then
						$link = StringReplace($grundpfad, "txt2htm", "html") & "keywords\" & $link ;neuen Pfad setzen
					EndIf
				Else
					$grundpfad_tmp = StringReplace($grundpfad, "txt2htm", "html") ;neuen Pfad setzen
					$link = StringReplace($link, "../", $grundpfad_tmp) ;neuen Pfad setzen
					$link = StringReplace($link, "..\", $grundpfad_tmp) ;neuen Pfad setzen
				EndIf
				If Not FileExists($link) And Not StringInStr($link, 'http://') Then ConsoleWrite(_log_schreiben($21, "")) ;Link fehlerhaft
			EndIf
		Next



		For $z = 1 To UBound($array_txt) - 1



			;*******************************************************************************
			;Funktionsname ermitteln
			;*******************************************************************************
			If $array_txt[$z] = "###Structure Name###" Or $array_txt[$z] = "###User Defined Function###" Or $array_txt[$z] = "###Keyword###" Or $array_txt[$z] = "###Function###" Then
				$funktion_art = 1 ;berschrift ber dem Funktionsname ist vorhanden
				If Not StringInStr($pfad, "txtKeywords") Then ;wenn keine Keywords Funktion
					$z += 1

					$split = StringSplit($array_txt[$z], ", ", 1)
					If UBound($split) = 2 Then ;falls im Funktionsname nur 1 Funktion steht
						$name_funktion_inhalt = $array_txt[$z]
						If $name_funktion_inhalt <> $name_funktion_dateiname Then _log_schreiben($1, "") ;Funktionsname bei ###Function### falsch
					ElseIf UBound($split) > 2 Then ;falls im Funktionsname 2 Funktionen getrennt durch Komma stehen
						$funktion_ok = 0
						For $o = 1 To UBound($split) - 1
							If $split[$o] = $name_funktion_dateiname Then
								$funktion_ok = 1
								ExitLoop
							EndIf
						Next
						If $funktion_ok = 0 Then _log_schreiben($1, "") ;Funktionsname bei ###Function### falsch
					EndIf
				EndIf



				;*******************************************************************************
				;Zeile in der sich das Wort Syntax befindet ermitteln
				;Zeile in der sich das 1. include befindet
				;*******************************************************************************
			ElseIf $array_txt[$z] = "###Syntax###" Then
				$syntax = 1 ;berschrift ber dem Syntax ist vorhanden
				$zeile_syntax_wort = $z ;Zeile in der sich das Wort Syntax befindet
				Do
					$z += 1
				Until Not StringInStr($array_txt[$z], "#Include")

				$zeile_syntax = $z ;Zeile in der sich der Syntax befindet
				If $zeile_syntax_wort + 1 = $zeile_syntax Then
					$zeile_include = "kein Include" ;Zeile in der sich das 1. include befindet
				Else
					$zeile_include = $zeile_syntax_wort + 1 ;Zeile in der sich das 1. include befindet
				EndIf

				$z = $zeile_syntax_wort ;Zeile wieder zurcksetzen



				;*******************************************************************************
				;Funktionsname im Syntax prfen
				;*******************************************************************************
			ElseIf $z = $zeile_syntax Then
				If Not StringInStr($pfad, "txtKeywords") Then ;wenn keine Keywords Funktion

					If StringInStr($array_dateien[$i], "$tag") Then ;bei $tag Funktionen
						$syntax_klammer = StringInStr($array_txt[$z], "=") ;Trennzeichen
					Else ;bei den sonstigen Funktionen
						$syntax_klammer = StringInStr($array_txt[$z], "(") ;Trennzeichen
					EndIf
					$syntax_funktion = StringLeft($array_txt[$z], $syntax_klammer - 1)
					$syntax_variablen = StringTrimLeft($array_txt[$z], $syntax_klammer) ;bei $tag Funktionen 1. Zeile Syntax rechte Seite (nur Variablen)
					$syntax_funktion = StringReplace($syntax_funktion, 'Global Const ', '') ;bei $tag Funktionen

					$syntax_funktion = StringStripWS($syntax_funktion, 3) ;Leerzeichen am Anfang und Ende entfernen

					If $syntax_funktion <> $name_funktion_dateiname Then _log_schreiben($2, "") ;Funktionsname im Syntax falsch



					;*******************************************************************************
					;Variablen im Syntax ermitteln (soll)
					;prfen, welche Variable im Syntax optional ist
					;*******************************************************************************
					If StringInStr($array_dateien[$i], "$tag") Then ;bei $tag Funktionen
						$verbinden = 0
						$var_tmp = 0
						Dim $nur_var[1]

						Do ;notwendig da der Syntax manchmal in mehreren Zeilen steht
							$array_tmp = $array_txt[$z]
							$nur_var[0] = $syntax_variablen
							If $verbinden = 1 Then ;notwendig wenn der Syntax in mehreren Zeilen steht
								$nur_var = _StringBetween($array_tmp, '"', '"')
								$nur_var[0] = $var_tmp & $nur_var[0]
							EndIf

							If StringRight($array_txt[$z], 1) = '_' Then
								$verbinden = 1
								$z += 1
								$var_tmp = $nur_var[0]
							Else
								ExitLoop
							EndIf
						Until Not StringRight($array_txt[$z], 1) = '_' ;solange bis die Zeile nicht mit "_" endet, dies bedeutet, dass der Syntax zu Ende ist und nicht in der nchsten Zeile fortgesetzt wird

						$exp_tmp = StringSplit($nur_var[0], ";")
					Else ;bei den sonstigen Funktionen
						$entf = $array_txt[$z]
						$entf = StringReplace($entf, "]", "")
						$nur_var = _StringBetween($entf, "(", ")")
						If IsArray($nur_var) Then
							If StringRight($nur_var[0], 1) = " " Then $nur_var[0] = StringTrimRight($nur_var[0], 1)
						EndIf
						$exp_tmp = StringSplit($nur_var[0], ",")
					EndIf

					;kompletter Syntax trennen und in ein Array schreiben
					If IsArray($exp_tmp) Then
						Dim $array_var_syn[UBound($exp_tmp)][2]
						For $b = 0 To UBound($exp_tmp) - 1
							$exp_tmp[$b] = StringReplace($exp_tmp[$b], '"', "")
							If StringInStr($exp_tmp[$b], "[") And StringInStr($exp_tmp[$b], "]") Then $exp_tmp[$b] = StringRegExpReplace($exp_tmp[$b], '[\[]+[\d]+[\]]', "") ;z. B. [16] ersetzen

							$exp_tmp[$b] = StringStripWS($exp_tmp[$b], 1) ;Leerzeichen am Anfang entfernen

							If StringInStr($exp_tmp[$b], "[") = 1 Then ; [ an erster Stelle finden
								$array_var_syn[$b][0] = StringReplace($exp_tmp[$b], "[", "") ;Parameter
								$array_var_syn[$b][1] = "optional" ;Parameter ist optional
							EndIf

							If StringInStr($exp_tmp[$b], "[", 1, 1, 2) Then ; [ an irgendeiner Stelle finden
								$array_var_syn[$b][0] = StringReplace($exp_tmp[$b], "[", "") ;Parameter
								$array_var_syn[$b + 1][1] = "optional" ;Parameter ist optional
							ElseIf Not StringInStr($exp_tmp[$b], "[") Then ; ohne [
								$array_var_syn[$b][0] = $exp_tmp[$b] ;Parameter
							EndIf
							If $b = 0 Then $array_var_syn[$b][0] = $exp_tmp[0] ;Parameter

							$array_var_syn[$b][0] = StringStripWS($array_var_syn[$b][0], 1) ;Leerzeichen am Anfang entfernen

							$pos_trim = StringInStr($array_var_syn[$b][0], "=")
							If $pos_trim > 0 Then $array_var_syn[$b][0] = StringLeft($array_var_syn[$b][0], $pos_trim - 1)
							$array_var_syn[$b][0] = StringRegExpReplace($array_var_syn[$b][0], '(ByRef)|(Const)', "") ;alles was in den Klammern steht entfernen

							If StringInStr($array_dateien[$i], "$tag") Then ;bei $tag Funktionen
								$array_var_syn[$b][0] = StringRegExpReplace($array_var_syn[$b][0], '(uint )|(UINT )|(int64 )|(int )|(ulong_ptr )|(ptr )|(dword )|(word )|(bool )|(long )|(ushort )|(short )|(ubyte )|(byte )|(hwnd )|(float )|(wchar )|(char )|(& _)|(& )', "") ;    alles was in den Klammern steht entfernen
							EndIf

							$array_var_syn[$b][0] = StringStripWS($array_var_syn[$b][0], 3) ;Leerzeichen am Anfang und Ende entfernen
						Next

						$anzahl_variablen_soll = UBound($array_var_syn) - 1 ;Includes im Syntax (soll)
					Else
						$anzahl_variablen_soll = 0 ;Includes im Syntax (soll)
					EndIf
				EndIf



				;*******************************************************************************
				;prft, ob die Includes die im Syntax angegeben sind auch existieren
				;*******************************************************************************
			ElseIf $z = $zeile_include Then
				If Not StringInStr($pfad, "txtKeywords") Then ;wenn keine Keywords Funktion
					Do
						If StringInStr($array_txt[$z], "#Include") Then
							$include_between = _StringBetween($array_txt[$z], "<", ">")
							If IsArray($include_between) Then
								If Not FileExists($pfad_include & $include_between[0]) Then _log_schreiben($3, "") ;angegebene Include-Datei existiert nicht
							EndIf
						EndIf
						$z += 1
					Until Not StringInStr($array_txt[$z], "#Include")
					$z -= 1
				EndIf



				;******************************************************************************************************************
				;Variablen in der Beschreibung ermitteln (ist) und diese mit den Variablen im Syntax (soll) vergleichen
				;prfen, welche Variable in der Beschreibung optional ist und dies mit den Variablen im Syntax vergleichen
				;******************************************************************************************************************
			ElseIf $variable_erledigt = 0 And $array_txt[$z] = "@@ParamTable@@" Then
				$variable_erledigt = 1 ;notwendig, da sonst die Fehlermeldung mit den Variablen mehrfach kommt
				$variable_optional = 0 ;das prfen des Wortes "[Optional]" zurcksetzen
				$anzahl_pro_datei = 0 ;fr das korrigieren der Dateien mit "[optional]"

				If Not StringInStr($pfad, "txtKeywords") Then ;wenn keine Keywords Funktion
					Local $array_txt_temp
					$array_txt_temp = $array_txt
					Do
						$z += 1
						If $array_zaehler < UBound($array_var_syn) Then
							$array_txt[$z] = StringRegExpReplace($array_txt[$z], '(ByRef)|(\()|(\))|(\	)|(\")', "") ;alles was in den Klammern steht entfernen
							$array_txt[$z] = StringStripWS($array_txt[$z], 3) ;Leerzeichen am Anfang und Ende entfernen

							If $array_txt[$z] = $array_var_syn[$array_zaehler][0] Then ;Variable des Syntax und Variable der Erklrung stimmt berein
								$z += 1
								If $array_var_syn[$array_zaehler][1] = "optional" And Not StringInStr($array_txt[$z], $wort_optional) Then ;Syntax = optional		Beschreibung = nicht optional
									_ArraySearch($array_auslassen_optional, $array_dateien[$i], 1)
									If @error Then ;bei bestimmten Sachen "optional" nicht suchen (z. B. x, y)
										$variable_optional = 1 ;bei bestimmten Sachen "optional" nicht suchen (z. B. x, y)
										$array_txt_temp[$z] = _StringInsert($array_txt_temp[$z], '[optional] ', 1)
										$anzahl_pro_datei += 1
									EndIf
								ElseIf Not $array_var_syn[$array_zaehler][1] = "optional" And StringInStr($array_txt[$z], $wort_optional) Then ;Syntax = nicht optional		Beschreibung = optional
									$variable_optional = 1
								EndIf
								$array_zaehler += 1
								$anzahl_variablen_ist += 1
							EndIf

							If $anzahl_pro_datei > 0 Then
								$pfad_kurz = StringReplace($pfad, $grundpfad, "")
								If Not FileExists($grundpfad_geaenderte & $pfad_kurz) Then DirCreate($grundpfad_geaenderte & $pfad_kurz)
								$name_test = $grundpfad_geaenderte & $pfad_kurz & $array_dateien[$i]
								_FileWriteFromArray($name_test, $array_txt_temp, 1)
							EndIf

						Else
							$array_txt[$z] = "@@End@@"
						EndIf

					Until $array_txt[$z] = "@@End@@"

					;Wenn ein Pflichtparameter auf einen optionalen Parameter folgt
					For $d = 2 To UBound($array_var_syn) - 1
						If $array_var_syn[$d][1] <> $array_var_syn[$d - 1][1] And $array_var_syn[$d][1] = "" Then
							_ArraySearch($array_auslassen_optional, $array_dateien[$i], 1)
							If @error Then $variable_optional = 1 ;bei bestimmten Sachen "optional" nicht suchen (z. B. x, y)
						EndIf
					Next

					If $variable_optional = 1 Then _log_schreiben($20, "") ;Das Wort "[optional]" fehlt, wurde falsch geschrieben oder ist unntig in der Beschreibung (mindestens bei einer Variable)

					If $anzahl_variablen_ist <> $anzahl_variablen_soll Then ;unterschiedliche Variablen
						$auslassen = 0 ;auslassen einer Funktion zurcksetzen

						For $e = 1 To UBound($array_auslassen_anz_var) - 1
							If $array_dateien[$i] = $array_auslassen_anz_var[$e][0] And $anzahl_variablen_ist = $array_auslassen_anz_var[$e][1] And $anzahl_variablen_soll = $array_auslassen_anz_var[$e][2] Then $auslassen = 1
						Next
						If $auslassen = 0 Then _log_schreiben($4, $anzahl_variablen_ist & " | " & $anzahl_variablen_soll) ;Anzahl Variablen / Variablen unterschiedlich geschrieben / Variablen in unterschiedlicher Reihenfolge
					EndIf
				EndIf



				;******************************************************************************************************************
				;Existieren die Funktionen in den verwandte Funktionen
				;Die Verknpfung zu mindestens einer verwandten Funktion ist doppelt vorhanden
				;******************************************************************************************************************
			ElseIf $array_txt[$z] = "###Related###" Then
				$verwandte_funcs = 1 ;berschrift ber den verwandten Funktionen ist vorhanden
				$z += 1
				If $z <= UBound($array_txt) - 1 Then ;sonst kommt ein Fehler wenn nach "Related" keine Zeile existiert
					$split_tmp = StringSplit($array_txt[$z], ", ", 1)

					If IsArray($split_tmp) Then
						For $h = 1 To UBound($split_tmp) - 1
							If StringLeft($split_tmp[$h], 1) = '.' Then $split_tmp[$h] = StringTrimLeft($split_tmp[$h], 1) ;manche Funktion haben einen Punkt davor, diesen entfernen
							If $split_tmp[$h] <> "" And Not StringInStr($split_tmp[$h], "(Option)") And Not StringInStr($split_tmp[$h], "Nichts") And Not StringInStr($split_tmp[$h], "Keine") And Not StringInStr($split_tmp[$h], "None") And Not StringInStr($split_tmp[$h], "Many") And Not StringInStr($split_tmp[$h], "Viele") And Not StringInStr($split_tmp[$h], "AutoItRelated") And Not StringInStr($split_tmp[$h], "AutoItSetOption") Then
;~ 								If StringInStr($array_dateien[$i], "guicrea") Then _ArrayDisplay($split_tmp)
								If StringInStr($split_tmp[$h], 'href') Then ;ein Link
									$split_tmp_bet = _StringBetween($split_tmp[$h], '"', '.htm')
									If IsArray($split_tmp_bet) Then $split_tmp[$h] = $split_tmp_bet[0]
									$split_tmp2 = StringSplit($split_tmp[$h], "/")
									If IsArray($split_tmp2) Then $split_tmp[$h] = $split_tmp2[UBound($split_tmp2) - 1]
									$split_tmp3 = StringSplit($split_tmp[$h], "\")
									If IsArray($split_tmp3) Then $split_tmp[$h] = $split_tmp3[UBound($split_tmp3) - 1]
								EndIf

								If Not StringInStr($split_tmp[$h], '..') And Not FileExists($pfad_1 & $split_tmp[$h] & ".txt") And Not FileExists($pfad_2 & $split_tmp[$h] & ".txt") And Not FileExists($pfad_3 & $split_tmp[$h] & ".txt") Then _log_schreiben($5, "")
								_Array2DAdd($array_alle_verwandte, $name_funktion_dateiname & "|" & $split_tmp[$h]) ;Array mit allen Funktionen und deren verwandten Funktionen erstellen
							EndIf
						Next

						$array_doppelt = _Array2DDblDel($split_tmp, 0) ;doppelte Funktionen finden
						If $array_doppelt = 1 And Not $array_dateien[$i] = "func.txt" Then _log_schreiben($6, "") ;doppelte erfassen (Func auslassen, da es dort gewollt ist)
						$array_gleiche_funktion = _ArraySearch($split_tmp, $name_funktion_dateiname)
						If $array_gleiche_funktion <> -1 Then _log_schreiben($7, "") ;Verwandte Funktion gleich der aktuellen Funktion
					EndIf
				EndIf



				;******************************************************************************************************************
				;berschrift ber der Beschreibung vorhanden?
				;berschrift ber den Parametern vorhanden?
				;berschrift ber dem Rckgabewert vorhanden?
				;berschrift ber den Bemerkungen vorhanden?
				;berschrift ber dem Beispiel vorhanden?
				;berschrift ber dem Beispiel vorhanden?
				;******************************************************************************************************************
			ElseIf $array_txt[$z] = "###Description###" Then
				$beschreibung = 1 ;berschrift ber der Beschreibung ist vorhanden
			ElseIf $array_txt[$z] = "###Parameters###" Or $array_txt[$z] = "###Fields###" Then
				$parameter = 1 ;berschrift ber den Parametern ist vorhanden
			ElseIf $array_txt[$z] = "###ReturnValue###" Then
				$rueckgabewert = 1 ;berschrift ber dem Rckgabewert ist vorhanden
			ElseIf $array_txt[$z] = "###Remarks###" Then
				$bemerkungen = 1 ;berschrift ber den Bemerkungen ist vorhanden
			ElseIf $array_txt[$z] = "###Example###" Then
				$beispiel = 1 ;berschrift ber dem Beispiel ist vorhanden
			ElseIf $array_txt[$z] = "@@IncludeExample@@" Then
				$beispiel_include = 1 ;berschrift ber dem Beispiel ist vorhanden
			EndIf
		Next



		;******************************************************************************************************************
		;berschrift ber der Art der Funktion vorhanden?
		;berschrift ber der Beschreibung vorhanden?
		;berschrift ber dem Syntax vorhanden?
		;berschrift ber den Parametern vorhanden?
		;berschrift ber dem Rckgabewert vorhanden?
		;berschrift ber den Bemerkungen vorhanden?
		;berschrift ber dem Verwandte Funktion vorhanden?
		;******************************************************************************************************************
		If StringInStr($array_dateien[$i], '$tag') Then ;bei Tag-Funktionen manche berschriften als vorhanden simulieren
			$rueckgabewert = 1 ;Rckgabewert existiert bei den $tag-Funktionen nicht
			$verwandte_funcs = 1 ;verwandte Funktionen existiert bei den $tag-Funktionen nicht
			$beispiel = 1 ;Beispiel existiert bei den $tag-Funktionen nicht
			$beispiel_include = 1 ;Beispiel existiert bei den $tag-Funktionen nicht
		Else
			If (Not FileExists($pfad_4 & $name_funktion_dateiname & ".au3") And Not FileExists($pfad_5 & $name_funktion_dateiname & ".au3")) And ($beispiel = 1 And $beispiel_include = 1) Then
				_log_schreiben($8, "") ;Eintrag fr das Beispiel vorhanden / Beispieldatei fehlt
			ElseIf (FileExists($pfad_4 & $name_funktion_dateiname & ".au3") Or FileExists($pfad_5 & $name_funktion_dateiname & ".au3")) And ($beispiel = 0 Or $beispiel_include = 0) Then
				_log_schreiben($9, "") ;Eintrag fr das Beispiel fehlt / Beispieldatei existiert
			EndIf
		EndIf

		If StringInStr($pfad, "txtKeywords") Then $rueckgabewert = 1 ;wenn Keywords Funktion

		If $tabelle_beginn <> $tabelle_ende Then _log_schreiben($10, "") ;Anzahl von @@End@@ stimmt nicht

		If $funktion_art = 0 Then _log_schreiben($11, "") ;berschrift fr Art der Funktion fehlt (z. B. ###Function###)
		If $beschreibung = 0 Then _log_schreiben($12, "") ;berschrift fr Beschreibung fehlt (###Description###)
		If $syntax = 0 Then _log_schreiben($13, "") ;berschrift fr Syntax fehlt (###Syntax###)
		If $parameter = 0 Then _log_schreiben($14, "") ;berschrift fr Parameter fehlt (###Parameters###)
		If $rueckgabewert = 0 Then _log_schreiben($15, "") ;berschrift fr Rckgabewert fehlt (###ReturnValue###)
		If $bemerkungen = 0 Then _log_schreiben($16, "") ;berschrift fr Bemerkungen fehlt (###Remarks###)
		If $verwandte_funcs = 0 Then _log_schreiben($17, "") ;berschrift fr Verwandte Funktion fehlt (###Related###)

	Next
EndFunc   ;==>_ermitteln



;*********************************************************
;alle Fehler in die Console ausgeben
;*********************************************************
Func _log_schreiben($text, $zusatz)
	If $text <> "" Then ;wenn der Parameter leer ist, wird nichts geschrieben (sinnvoll, falls nur ein bestimmter Fehler gesucht werden soll)
		If $name_funktion_dateiname <> $name_funktion_dateiname_merken Then $anzahl_fehler += 1
		If $zusatz = "" Then
			ConsoleWrite($anzahl_fehler & @TAB & $name_funktion_dateiname & @TAB & @TAB & $text & @CRLF) ;Fehler in die Console schreiben
		Else
			ConsoleWrite($anzahl_fehler & @TAB & $name_funktion_dateiname & @TAB & @TAB & $text & @TAB & $zusatz & @CRLF) ;Fehler in die Console schreiben
		EndIf
		$name_funktion_dateiname_merken = $name_funktion_dateiname
	EndIf
EndFunc   ;==>_log_schreiben



;*********************************************************
; ;fehlende verwandte Funktionen ermitteln
;*********************************************************
Func _verwandte_fehlen()
	For $i = 1 To UBound($array_alle_verwandte) - 1
		If $array_alle_verwandte[$i][1] = "GUICtrlCreate..." Then
			For $z = 1 To UBound($array_sammelfunc_1) - 1
				_Array2DAdd($array_alle_verwandte, $array_alle_verwandte[$i][0] & "|" & $array_sammelfunc_1[$z])
				_Array2DAdd($array_alle_verwandte, $array_sammelfunc_1[$z] & "|" & $array_alle_verwandte[$i][0])
			Next
			_Array2DDelete($array_alle_verwandte, $i)
			$i -= 1
		ElseIf $array_alle_verwandte[$i][1] = "GUICtrlUpdate..." Then
			For $z = 1 To UBound($array_sammelfunc_2) - 1
				_Array2DAdd($array_alle_verwandte, $array_alle_verwandte[$i][0] & "|" & $array_sammelfunc_2[$z])
				_Array2DAdd($array_alle_verwandte, $array_sammelfunc_2[$z] & "|" & $array_alle_verwandte[$i][0])
			Next
			_Array2DDelete($array_alle_verwandte, $i)
			$i -= 1
		ElseIf $array_alle_verwandte[$i][1] = "GUISetParameters..." Then
			For $z = 1 To UBound($array_sammelfunc_3) - 1
				_Array2DAdd($array_alle_verwandte, $array_alle_verwandte[$i][0] & "|" & $array_sammelfunc_3[$z])
				_Array2DAdd($array_alle_verwandte, $array_sammelfunc_3[$z] & "|" & $array_alle_verwandte[$i][0])
			Next
			_Array2DDelete($array_alle_verwandte, $i)
			$i -= 1
		EndIf
	Next

	For $i = 1 To UBound($array_alle_verwandte) - 1
		$suchbegriff = $array_alle_verwandte[$i][1]
		$verwandte = $array_alle_verwandte[$i][0]
		$gefunden = 0
		If Not StringInStr($suchbegriff, '(Option)') And Not StringInStr($suchbegriff, '$tag') Then
			If (StringLeft($suchbegriff, 1) = "_" And StringLeft($verwandte, 1) = "_") Or (StringLeft($suchbegriff, 1) <> "_" And StringLeft($verwandte, 1) <> "_") Then
				For $z = 1 To UBound($array_alle_verwandte) - 1
					If $array_alle_verwandte[$z][0] = $suchbegriff And $array_alle_verwandte[$z][1] = $verwandte Then
						$gefunden = 1
						ExitLoop
					EndIf
				Next
				$name_funktion_dateiname = $verwandte

				If $check_backref = 0 Then
					For $z = 1 to Ubound($array_nobackref) -1
						If $array_nobackref[$z] = $suchbegriff Then
							$gefunden = 1
							ExitLoop
						EndIf
					Next
				EndIf

				If $gefunden = 0 Then
					$iniread = IniRead($ini_verwandte, "verwandte", $suchbegriff, "")
					If $iniread = "" Then
						IniWrite($ini_verwandte, "verwandte", $suchbegriff, $verwandte)
					Else
						IniWrite($ini_verwandte, "verwandte", $suchbegriff, $iniread & ", " & $verwandte)
					EndIf

					If StringInStr($19, "gegen") Then
						_log_schreiben($19, $verwandte & " verweist auf " & $suchbegriff & "." & @TAB & "Andersrum aber nicht") ;deutsch
					Else
						_log_schreiben($19, $verwandte & " refers to " & $suchbegriff & "." & @TAB & "But not the other way") ;englisch
					EndIf
				EndIf
			EndIf
		EndIf
	Next
EndFunc   ;==>_verwandte_fehlen
